/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.world.structure;

import com.eeeab.eeeabsmobs.sever.entity.impl.immortal.EntityImmortalKnight;
import com.eeeab.eeeabsmobs.sever.entity.impl.immortal.EntityImmortalShaman;
import com.eeeab.eeeabsmobs.sever.entity.impl.namelessguardian.EntityNamelessGuardian;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.eeeab.eeeabsmobs.sever.init.StructuresInit;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariants;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.Vec3;

public class AncientTombStructure
extends Structure {
    public static final Codec<AncientTombStructure> CODEC = AncientTombStructure.m_226607_(AncientTombStructure::new);
    private static final ResourceLocation ANCIENT_TOMB_1 = new ResourceLocation("eeeabsmobs", "ancient_tomb_1");
    private static final ResourceLocation ANCIENT_TOMB_2 = new ResourceLocation("eeeabsmobs", "ancient_tomb_2");
    private static final ResourceLocation ANCIENT_TOMB_3 = new ResourceLocation("eeeabsmobs", "ancient_tomb_3");
    private static final ResourceLocation ANCIENT_TOMB_4 = new ResourceLocation("eeeabsmobs", "ancient_tomb_4");
    private static final Map<ResourceLocation, BlockPos> OFFSET = new ImmutableMap.Builder().put((Object)ANCIENT_TOMB_1, (Object)new BlockPos(0, 1, 0)).put((Object)ANCIENT_TOMB_2, (Object)new BlockPos(0, 1, 0)).put((Object)ANCIENT_TOMB_3, (Object)new BlockPos(0, 1, 0)).put((Object)ANCIENT_TOMB_4, (Object)new BlockPos(0, 1, 0)).build();

    protected AncientTombStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        BlockPos blockPos = new BlockPos(context.f_226628_().m_45604_(), -64, context.f_226628_().m_45605_());
        return Optional.of(new Structure.GenerationStub(blockPos, value -> AncientTombStructure.generatePieces(value, context)));
    }

    private static void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        BlockPos blockpos = new BlockPos(context.f_226628_().m_45604_(), -64, context.f_226628_().m_45605_());
        Rotation rotation = Rotation.NONE;
        AncientTombStructure.start(context.f_226625_(), blockpos, rotation, builder, context.f_226626_());
    }

    private static void start(StructureTemplateManager manager, BlockPos pos, Rotation rotation, StructurePiecesBuilder builder, WorldgenRandom random) {
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        BlockPos rotationOffset = new BlockPos(27, 1, 27).m_7954_(rotation);
        BlockPos blockPos = rotationOffset.m_7918_(x, pos.m_123342_(), z);
        builder.m_142679_((StructurePiece)new Piece(manager, ANCIENT_TOMB_1, rotation, blockPos));
        rotationOffset = new BlockPos(1, 1, 27).m_7954_(rotation);
        blockPos = rotationOffset.m_7918_(x, pos.m_123342_(), z);
        builder.m_142679_((StructurePiece)new Piece(manager, ANCIENT_TOMB_2, rotation, blockPos));
        rotationOffset = new BlockPos(1, 1, 1).m_7954_(rotation);
        blockPos = rotationOffset.m_7918_(x, pos.m_123342_(), z);
        builder.m_142679_((StructurePiece)new Piece(manager, ANCIENT_TOMB_3, rotation, blockPos));
        rotationOffset = new BlockPos(27, 1, 1).m_7954_(rotation);
        blockPos = rotationOffset.m_7918_(x, pos.m_123342_(), z);
        builder.m_142679_((StructurePiece)new Piece(manager, ANCIENT_TOMB_4, rotation, blockPos));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)StructuresInit.ANCIENT_TOMB_STRUCTURE.get();
    }

    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public static class Piece
    extends TemplateStructurePiece {
        public Piece(StructureTemplateManager manager, ResourceLocation location, Rotation rotation, BlockPos blockPos) {
            super((StructurePieceType)StructuresInit.ATP.get(), 0, manager, location, location.toString(), Piece.makeSettings(rotation), Piece.makePosition(location, blockPos));
        }

        public Piece(StructureTemplateManager templateManagerIn, CompoundTag tagCompound) {
            super((StructurePieceType)StructuresInit.ATP.get(), tagCompound, templateManagerIn, location -> Piece.makeSettings(Rotation.valueOf((String)tagCompound.m_128461_("Rot"))));
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tag) {
            this(context.f_226956_(), tag);
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation) {
            BlockIgnoreProcessor blockignoreprocessor = BlockIgnoreProcessor.f_74046_;
            return new StructurePlaceSettings().m_74379_(rotation).m_74377_(Mirror.NONE).m_74383_((StructureProcessor)blockignoreprocessor).m_74383_((StructureProcessor)new ProtectedBlockProcessor(BlockTags.f_144287_));
        }

        private static BlockPos makePosition(ResourceLocation location, BlockPos blockPos) {
            return blockPos.m_121955_((Vec3i)OFFSET.get(location));
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag compoundTag) {
            super.m_183620_(context, compoundTag);
            compoundTag.m_128359_("Rot", this.f_73657_.m_74404_().name());
        }

        protected void m_213704_(String function, BlockPos blockPos, ServerLevelAccessor levelAccessor, RandomSource source, BoundingBox box) {
            if ("nameless_guardian_spawn".equals(function)) {
                levelAccessor.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
                EntityNamelessGuardian guardian = (EntityNamelessGuardian)((EntityType)EntityInit.NAMELESS_GUARDIAN.get()).m_20615_((Level)levelAccessor.m_6018_());
                if (guardian != null) {
                    guardian.m_20035_(blockPos, 180.0f, 180.0f);
                    guardian.m_6518_(levelAccessor, levelAccessor.m_6436_(blockPos), MobSpawnType.STRUCTURE, null, null);
                    levelAccessor.m_7967_((Entity)guardian);
                }
            }
            if ("painting".equals(function)) {
                levelAccessor.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
                ResourceKey[] variants = new ResourceKey[]{PaintingVariants.f_218932_, PaintingVariants.f_218933_, PaintingVariants.f_218913_};
                Optional holder = Registry.f_235728_.m_203636_(variants[levelAccessor.m_213780_().m_188503_(variants.length)]);
                if (holder.isPresent()) {
                    Painting painting = new Painting((Level)levelAccessor.m_6018_(), blockPos, this.f_73657_.m_74404_().m_55954_(Direction.EAST), (Holder)holder.get());
                    levelAccessor.m_7967_((Entity)painting);
                }
            }
            if ("immortal_shaman_spawn".equals(function)) {
                levelAccessor.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
                EntityImmortalShaman shaman = (EntityImmortalShaman)((EntityType)EntityInit.IMMORTAL_SHAMAN.get()).m_20615_((Level)levelAccessor.m_6018_());
                if (shaman != null) {
                    shaman.m_20219_(Vec3.m_82512_((Vec3i)blockPos));
                    shaman.m_6518_(levelAccessor, levelAccessor.m_6436_(blockPos), MobSpawnType.STRUCTURE, null, null);
                    shaman.m_146922_(shaman.m_146908_() + 180.0f);
                    levelAccessor.m_7967_((Entity)shaman);
                }
            }
            if ("immortal_knight_spawn".equals(function)) {
                levelAccessor.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
                EntityImmortalKnight knight = (EntityImmortalKnight)((EntityType)EntityInit.IMMORTAL_KNIGHT.get()).m_20615_((Level)levelAccessor.m_6018_());
                if (knight != null) {
                    knight.m_20219_(Vec3.m_82512_((Vec3i)blockPos));
                    knight.m_6518_(levelAccessor, levelAccessor.m_6436_(blockPos), MobSpawnType.STRUCTURE, null, null);
                    knight.m_146922_(knight.m_146908_() + 180.0f);
                    levelAccessor.m_7967_((Entity)knight);
                }
            }
            if ("key".equals(function)) {
                levelAccessor.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
            }
        }
    }
}

